#include <ESP8266WiFi.h>
#include "ThingSpeak.h"

//To connect with thingspeak
String apiKey = "R3FHLI5AFZGP64GW"; // Enter your API key from ThingSpeak ˇ API key from our project: "R3FHLI5AFZGP64GW"
const char* ssid = "RedeCasa"; // Give your wifi network name
const char* password = "914800180"; // Give your wifi network password
const char* server = "api.thingspeak.com";

int number1;
int number2;

WiFiClient client; //create a client object

void setup()
{
  Serial.begin(9600);
  delay(10);
  WiFi.begin(ssid, password);
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(500);
    Serial.print(".");
  }//wait till the connection is estabilished
  Serial.println("");
  Serial.println("WiFi connected");
}

void loop()
{

  if (client.connect(server, 80))
  {
    number1 = random(0,100); //random number 1
    number2 = random(0,100); //random number 2
    
    String postStr = apiKey;
    postStr += "&field1=";
    postStr += String(number1);
    postStr += "&field2=";
    postStr += String(number2);
    postStr += "\r\n\r\n";
    client.print("POST /update HTTP/1.1\n");
    client.print("Host: api.thingspeak.com\n");
    client.print("Connection: close\n");
    client.print("X-THINGSPEAKAPIKEY: " + apiKey + "\n");
    client.print("Content-Type: application/x-www-form-urlencoded\n");
    client.print("Content-Length: ");
    client.print(postStr.length());
    client.print("\n\n");
    client.print(postStr);
    Serial.println(postStr);
  }
  client.stop();
  Serial.print("Number 1: ");
  Serial.print(number1);
  Serial.print("Number 2: ");
  Serial.print(number2);
  Serial.println(" Send to Thingspeak.");
  Serial.println("Waiting...");
  
  delay(30000); //wait 30 s
}
